package gov.va.med.mhv.sm.admin.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.sm.admin.model.Clinician;
import gov.va.med.mhv.sm.admin.model.SMPatient;
import gov.va.med.mhv.sm.admin.model.SMUser;


@Repository
public interface SMUserRepository extends JpaRepository<SMUser, Long>{

	
	/**
	 * findUserById
	 * @param id
	 * @return SMSUser
	 */
	@Query("select u from SMUser u where u.id = :id")
	SMUser findUserById(@Param("id") Long id);

	
	/**
	 * findPatientById
	 * @param id
	 * @return SMSPatient
	 */
	@Query("select p from SMPatient p where p.id = :id")
	SMPatient findPatientById(@Param("id") Long id);
	
	/**
	 * findClinicianById
	 * @param id
	 * @return SMSClinician
	 */
	@Query("select c from Clinician c where c.id = :id")
	Clinician findClinicianById(@Param("id") Long id);

}